% Script for plotting iso CO2-solubility contours based on the Duan and Sun EoS
% as a function of pressure and temperature. Script uses data output file from PHREEQC geochemical model

clear
close all
clc

% Import data from text file, specify file location
filename = 'co2_solubility_phreeqc_high_salinity_DuanSun.txt';
import_data;

% Temperature, pressure and solubility data
T = data(:,26);
p = data(:,27);
solCO2 = -data(:,22);

% Create pressure and temperature vectors for plotting and matrix of
% solubility data for creating contours

% Determining size of matrix
N = find(p-p(1) > 0,1) - 1;
M = length(p)/N;

% Set up temperature and pressure vectors
Tvec = T(1:N);
pvec = p(1:N:end);

% Initiatie solubility matrix
solCO2mat = zeros(M,N);

for i = 1:M
    solCO2mat(i,:) = solCO2(((i-1)*N)+[1:N]);
end

% Plot CO2 solubility data as a function of pressure and temperature
figure('Position',[50 50 1000 800])

[C,h] = contourf(Tvec-273.15,pvec*10,solCO2mat,[-0.01:0.02:0.22],'ShowText','on','LineWidth',1.5,'Color',[1 1 1]);
clabel(C,h,'FontSize',16,'FontName','helvetica','Color',[1 1 1])
set(gca,'FontSize',18,'FontName','helvetica')
xlabel('T [C]');
ylabel('p [bar]');

%% Experimental results

% 150 mmol/kgw results, temperature [C] and pressure [bar] of first observed bubble
Te_150 = [40 60 100 120];
pe_150 = [39 83 146 166];


% Plot experimental data as symbols in the same figure
hold on
% plot(Te_150,pe_150,'ko','MarkerFaceColor','k','MarkerSize',12);
plot(Te_150,pe_150,'ks','MarkerFaceColor','k','MarkerSize',10);
axis([25 200 0 200])
c = colorbar;
c.Label.String = 'CO_2 solubility [mol/kgw]';